'use strict'

entityRegistry['module']['bling'] = {
    extendedInfo: {
        displayName: 'Bling',
        displayGroup: 'Post Processing',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'blingColor', displayName: 'Bling Color', type: 'int', defaultValue: 1},
        { paramName: 'blurPasses', displayName: 'Blur Passes', type: 'int', defaultValue: 1, uiOptions: { min: 1 }},
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 2},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                blingColor,
                blurPasses,
                strength,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const colorBufferData = colorBuffer.data
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const brightnessBufferData = brightnessBuffer.data
            const bufferWidth = colorBuffer.width
            const bufferHeight = colorBuffer.height
            const halfBufferWidth = bufferWidth / 2
            const halfBufferHeight = bufferHeight / 2

            // Downsample
            let dst2Id = renderer.lockBuffer('brightness')
            let dst1Id = renderer.lockBuffer('brightness')
            let dst1 = renderer.getBufferFromId('brightness', dst1Id).data
            let dst2 = renderer.getBufferFromId('brightness', dst2Id).data
            let writeIndex = 0
            for (let y = 0; y < bufferHeight; y+=2) {
                for (let x = 0; x < bufferWidth; x+=2) {
                    const index = (y+1)*bufferWidth + x+1
                    if (colorBufferData[index] === blingColor) {
                        dst1[writeIndex++] = strength
                    } else {
                        dst1[writeIndex++] = 0
                    }
                }
            }

            // Blur
            for (let i = 0; i < blurPasses; ++i) {
                {
                    let index = 0
                    for (let x = 0; x < halfBufferWidth; ++x) dst2[index] = dst1[index++]
                    for (let y = 1; y < halfBufferHeight-1; ++y) {
                        dst2[index] = dst1[index++]
                        for (let x = 1; x < halfBufferWidth-1; ++x) {
                            const v = (dst1[index-halfBufferWidth-1] +
                                       dst1[index-halfBufferWidth+1] +
                                       dst1[index] +
                                       dst1[index+halfBufferWidth-1] +
                                       dst1[index+halfBufferWidth+2]) / 5
                            dst2[index++] = v
                        }
                        dst2[index] = dst1[index++]
                    }
                    for (let x = 0; x < halfBufferWidth; ++x) dst2[index] = dst1[index++]
                }
                //[dst1, dst2] = [dst2, dst1]
                const swap=dst1; dst1=dst2; dst2=swap
                const swapId=dst1Id; dst1Id=dst2Id; dst2Id=swapId
            }

            // Glow
            const src = dst1
            const dst = brightnessBufferData
            let index = 0
            for (let y = 0; y < bufferHeight; ++y) {
                for (let x = 0; x < bufferWidth; ++x) {
                    const v = src[(y>>1)*halfBufferWidth+(x>>1)]
                    if (v) {
                        dst[index] += v
                    }
                    index++
                }
            }

            renderer.unlockBuffer('brightness', dst2Id)
            renderer.unlockBuffer('brightness', dst1Id)
        }
    }
}
